	subroutine kbivar(n,x,y,xt,yt,rho,f)
	parameter(maxn=500)
  	implicit double precision (a-h,p-z)
	double precision xt(maxn),yt(maxn)
c
	hx=.85*(1.0-rho**2.)**(5./12.)*(1+rho**2./2.)**(-1./6.)
     + *dble(n)**(-1./6.)
	hy=hx
c   ********   For testing
c	hx=.85*dble(n)**(-1./6.) 
c	hy=hx
c   ***********
	f=0.0
	do i=1,n
	   f=f+dtpdf((x-xt(i))/hx)*dtpdf((y-yt(i))/hy) 
	enddo
	f=f/(dble(n)*hx*hy)
c
	return
	end
c
	subroutine kuniv(n,x,xt,f)
	parameter(maxn=500)
  	implicit double precision (a-h,p-z)
	double precision xt(maxn)
c
	hx=.85*dble(n)**(-1./5.) 
	f=0.0
	do i=1,n
	   f=f+dtpdf((x-xt(i))/hx) 
	enddo
	f=f/(dble(n)*hx)
c
	return
	end
c
	double precision function dnorm(x)
	implicit double precision (a-h,p-z)
c
      pi=4.0d0*datan(1.0d0)
c
	dnorm=dexp(-.5d0*(x**2.0d0))
	dnorm=dnorm/dsqrt(2.0d0*pi)
c
	return
	end
c
	double precision function dtpdf(x)
	implicit double precision (a-h,p-z)
	parameter(df=4.0d0)
c
      pi=4.0d0*datan(1.0d0)
c
	dtpdf=(1.0d0+x**2.0d0/df)**(-(df+1.0d0)/2.0d0)
	dtpdf=dtpdf/dsqrt(pi*df)
	dtpdf=dtpdf*DGAMMA((df+1.0d0)/2.0d0)*DGAMR(df/2.0d0)
c
	return
	end
c
	subroutine hbivar2(in,n,xt,yt,h,rho)
	parameter(maxn=500,inmx=30)
  	implicit double precision (a-h,p-z)
	double precision xt(maxn),yt(maxn)
	double precision qx(inmx),qwx(inmx),fx(inmx),fy(inmx) 
	double precision xts(maxn),xlow(2),xupp(2) 
c
	rho=0.0d0
	do i=1,n
	   rho=rho+xt(i)*yt(i)
	enddo
	rho=rho/dble(n) 
c     Find max and min of xt and yt 
	CALL DSVRGN (N, xt, xts)
	xlow(1)=xts(1) 
	xupp(1)=xts(n) 
 	CALL DSVRGN (N, yt, xts)
	xlow(2)=xts(1) 
	xupp(2)=xts(n) 
	ndim=2
      CALL DGQRUL (in,1,0.0d0,0.0d0,0,QXFIX,QX,QWX)
	do i=1,in
         tempx=qx(i)*(xupp(1)-xlow(1)+2.)/2.0+(xupp(1)+xlow(1))/2.0
         tempy=qx(i)*(xupp(2)-xlow(2)+2.)/2.0+(xupp(2)+xlow(2))/2.0
         call kuniv(n,tempx,xt,fx(i))
         call kuniv(n,tempy,yt,fy(i))
	enddo
	h=0.0d0
	do i=1,in
	   do j=1,in
         tempx=qx(i)*(xupp(1)-xlow(1)+2.)/2.0+(xupp(1)+xlow(1))/2.0
         tempy=qx(j)*(xupp(2)-xlow(2)+2.)/2.0+(xupp(2)+xlow(2))/2.0
         call kbivar(n,tempx,tempy,xt,yt,rho,f)
         h=h+(dlog(f)-dlog(fx(i))-dlog(fy(j)))*f*qwx(i)*qwx(j)
	   enddo
	enddo
	h=h*(xupp(1)-xlow(1)+2.)*(xupp(2)-xlow(2)+2.)/4.d0
c	
      return
	end    	  
